% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{car_alone}
\alias{car_alone}
\title{Atomic habits survey}
\format{
\itemize{
\item column 1, a combination of being able and feeling restrictive
\item column 2, justify your answer
}
}
\source{
Applied mathematics department, Institut Agro Rennes-Angers
}
\usage{
car_alone
}
\description{
People think they need to make big changes to change
the course of their lives. But in James Clear's book,
Atomic Habits, they will discover that the smallest of changes,
coupled with a good knowledge of psychology and neuroscience,
can have a revolutionary effect on their lives and relationships.
To understand this concept of atomic habits, we interviewed 167 people
and asked them if they were able to never take their car alone again,
to buy local products...
We also asked them how restrictive they found this and why.
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(FactoMineR)
library(NaileR)
library(dplyr)
data(car_alone)
sampled_car_alone <- car_alone \%>\%
group_by(car_alone_capable_restrictive) \%>\%
sample_frac(0.5)
sampled_car_alone <- as.data.frame(sampled_car_alone)

intro_car <- "Knowing the impact on the climate,
I have made these choices based on
the following benefits and constraints..."
intro_car <- gsub('\n', ' ', intro_car) |>
stringr::str_squish()
res_nail_textual <- nail_textual(sampled_car_alone, num.var = 1,
                                num.text = 2,
                                introduction = intro_car,
                                request = NULL,
                                model = 'llama3', isolate.groups = TRUE,
                                generate = TRUE)
res_nail_textual[[1]]$response |> cat()
res_nail_textual[[3]]$response |> cat()
res_nail_textual[[2]]$response |> cat()
res_nail_textual[[4]]$response |> cat()
}
}
\keyword{datasets}
