% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NancySimulation.R
\name{simu_config}
\alias{simu_config}
\title{Configuration function}
\usage{
simu_config(
  I = 100,
  k = 10,
  R = 2,
  correlation_t = 0,
  potential_correlation_s = rep(0.5, 4),
  AUC_all = rep(0.7, 2),
  sameclustersize = TRUE,
  rho = 0.5,
  fix_design = FALSE,
  stream = 20220210,
  initial_seed = 20220222
)
}
\arguments{
\item{I}{The number of patients.}

\item{k}{The number of ROIs in each patient.}

\item{R}{The number of readers.}

\item{correlation_t}{The correlation for simulating truth label.}

\item{potential_correlation_s}{The correlation for simulating reading scores.}

\item{AUC_all}{The theoretical AUC values.}

\item{sameclustersize}{The binary variable to decide whether we have same number of ROIs in each patient.}

\item{rho}{The scale parameter that influence the covariance matrix in multivariate normal distribution.}

\item{fix_design}{Binary variable to decide whether fix the truth label in simulation.}

\item{stream}{The integer control the random number generator.}

\item{initial_seed}{The integer control the random seed for truth label generation.}
}
\value{
A list of above parameters
}
\description{
Configuration function
}
