% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{risk}
\alias{risk}
\title{computes a Monte Carlo approximation of an estimator's Bayes risk}
\usage{
risk(
  assessment,
  loss = function(x, y) abs(x - y),
  average_over_parameters = FALSE,
  average_over_sample_sizes = TRUE
)
}
\arguments{
\item{assessment}{an object returned by \code{\link[=assess]{assess()}}}

\item{loss}{a binary operator defining the loss function (default absolute-error loss)}

\item{average_over_parameters}{if \code{TRUE}, the loss is averaged over all parameters; otherwise (default), the loss is averaged over each parameter separately}

\item{average_over_sample_sizes}{if \code{TRUE} (default), the loss is averaged over all sample sizes (the column \code{m} in \code{df}); otherwise, the loss is averaged over each sample size separately}
}
\value{
a dataframe giving an estimate of the Bayes risk
}
\description{
computes a Monte Carlo approximation of an estimator's Bayes risk
}
\seealso{
\code{\link[=assess]{assess()}}, \code{\link[=bias]{bias()}}, \code{\link[=rmse]{rmse()}}
}
