% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column-utilities.R
\name{ColumnUtilities}
\alias{ColumnUtilities}
\alias{VerifyColumnExists}
\alias{RenameColumn}
\alias{RenameNlsyColumn}
\title{A collection of functions that helps data management data.frames, particularly those derived from NLSY Extracts.}
\usage{
VerifyColumnExists( dataFrame, columnName )

RenameColumn( dataFrame, oldColumnName, newColumnName )

RenameNlsyColumn( dataFrame, nlsyRNumber, newColumnName )
}
\arguments{
\item{dataFrame}{The \link[base:data.frame]{base::data.frame} whose columns are to be verified or renamed.}

\item{columnName}{The name of the column to verify is present in the \link[base:data.frame]{base::data.frame}.}

\item{nlsyRNumber}{The name of the column to change.}

\item{oldColumnName}{The name of the column to change.}

\item{newColumnName}{The desired name of the column.}
}
\value{
\emph{IMPORTANT} The \code{\link[=RenameColumn]{RenameColumn()}} and \code{\link[=RenameNlsyColumn]{RenameNlsyColumn()}} functions do not use side-effects to rename the \link[base:data.frame]{base::data.frame}.  Instead, it returns a new \link[base:data.frame]{base::data.frame}.  In the example below, notice the assignment to \code{ds}: \code{ds <- RenameNlsyColumn(...)}.

The \code{\link[=VerifyColumnExists]{VerifyColumnExists()}} function check that exactly one column exists with the specified \code{columnName}.  If so, the index of the column is returned.  If not, an exception is thrown.
}
\description{
A collection of functions that helps data management \link[base:data.frame]{base::data.frame}s, particularly those derived from NLSY Extracts.
}
\details{
The RNumber assigned by the NLS has a pattern.  In the Nlsy79 Gen1 dataset, the names start with a 'R' or 'T' and are followed by seven digits (eg, R0000100).  In the Nlsy79 Gen2 dataset, the names start with 'C' or 'Y' and are followed by seven digits (eg, C0007030, Y1994600).

In the NLS Investigator, a decimal is present in the RNumber (eg, R00001.00).  When the Investigator saves the dataset as a CSV, the decimal is removed (eg, R0000100).
}
\author{
Will Beasley
}
