% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtUniform.R
\name{MvtUniform}
\alias{MvtUniform}
\alias{dmvunif}
\alias{pmvunif}
\alias{qmvunif}
\alias{rmvunif}
\alias{smvunif}
\title{Cook-Johnson's Multivariate Uniform Distribution}
\usage{
dmvunif(x, parm = 1, log = FALSE)

pmvunif(q, parm = 1)

qmvunif(p, parm = 1, dim = k, interval = c(0, 1))

rmvunif(n, parm = 1, dim = 1)

smvunif(q, parm = 1)
}
\arguments{
\item{x}{vector or matrix of quantiles. If \eqn{x} is a matrix, each row vector constitutes a vector of quantiles for which the density \eqn{f(x)} is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{parm}{a scalar parameter, see parameter \eqn{a} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities \eqn{f} are given as \eqn{log(f)}.}

\item{q}{a vector of quantiles.}

\item{p}{a scalar value corresponding to probability.}

\item{dim}{dimension of data or number of variates (k).}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(0, 1)}.}

\item{n}{number of observations.}
}
\value{
\code{dmvunif} gives the numerical values of the probability density.

\code{pmvunif} gives the cumulative probability.

\code{qmvunif} gives the equicoordinate quantile.

\code{rmvunif} generates random numbers.

\code{smvunif} gives the value of survival function.
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for Cook-Johnson’s multivariate uniform distribution with a scalar parameter \code{parm}.
}
\details{
Multivariate uniform distribution of Cook and Johnson (1981) is a joint distribution of uniform variables over \eqn{(0,1]} and its probability density is given as
\deqn{f(x_1, \cdots, x_k) = \frac{\Gamma(a+k)}{\Gamma(a)a^k}\prod_{i=1}^{k} x_i^{(-1/a)-1} \left[\sum_{i=1}^{k} x_i^{-1/a} - k +1 \right]^{-(a+k)},}
where \eqn{0 < x_i <=1, a>0, i=1,\cdots, k}. In fact, Cook-Johnson's uniform distribution is also called Clayton copula (Nelsen, 2006).

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is given as
\deqn{F(x_1, \cdots, x_k) = \left[ \sum_{i=1}^{k} x_i^{-1/a} - k + 1 \right]^{-a}.}

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{0}^{q} \cdots \int_{0}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

The survival function \eqn{\bar{F}(x_1, \cdots, x_k)} is obtained by the following formula related to cumulative distribution function \eqn{F(x_1, \dots, x_k)} (Joe, 1997)
\deqn{\bar{F}(x_1, \cdots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} F_S(x_j, j \in S).}

Random numbers \eqn{X_1, \cdots, X_k} from Cook-Johnson’s multivariate uniform distribution can be generated through transformation of multivariate Lomax random variables \eqn{Y_1, \cdots, Y_k} by letting \eqn{X_i = (1+\theta_i Y_i)^{-a}, i = 1, \cdots, k}; see Nayak (1987).
}
\examples{
# Calculations for the Cook-Johnson's multivariate uniform distribution with parameters:
# a = 2, dim = 3
# Vector of quantiles: c(0.8, 0.5, 0.2)

dmvunif(x = c(0.8, 0.5, 0.2), parm = 2) # Density

pmvunif(q = c(0.8, 0.5, 0.2), parm = 2) # Cumulative Probability

# Equicoordinate quantile of cumulative probability 0.5
qmvunif(p = 0.5, parm = 2, dim = 3)

# Random numbers generation with sample size 100
rmvunif(n = 100, parm = 2, dim = 3)

smvunif(q = c(0.8, 0.5, 0.2), parm = 3) # Survival function

}
\references{
Cook, R. E. and Johnson, M. E. (1981). A family of distributions for modeling non-elliptically symmetric multivariate data. \emph{J.R. Statist. Soc}. B 43, No. 2, 210-218.

Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.

Nelsen, R. B. (2006). \emph{An Introduction to Copulas, Second Edition}. New York: Springer.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
