% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precipitation_surplus.R
\name{calc_psp}
\alias{calc_psp}
\title{Calculate the precipitation surplus}
\usage{
calc_psp(B_LU_BRP, M_GREEN)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{M_GREEN}{(boolean) A soil measure. Are catch crops sown after main crop (optional, options: TRUE, FALSE)}
}
\value{
The estimated precipitation surplus (in mm / ha) depending on averaged precipitation and evaporation. A numeric value.
}
\description{
This function calculates the precipitation surplus (in mm / ha) given the crop rotation plan.
}
\examples{
calc_psp(B_LU_BRP = 265, M_GREEN = TRUE)
calc_psp(B_LU_BRP = c(265,1019,265,1019), M_GREEN = rep(TRUE,4))

}
