% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potassium.R
\name{ind_potassium}
\alias{ind_potassium}
\title{Calculate the indicator for Potassium Availability}
\usage{
ind_potassium(D_K, B_LU_BRP, B_SOILTYPE_AGR, A_SOM_LOI)
}
\arguments{
\item{D_K}{(numeric) The value of K-index calculated by \code{\link{calc_potassium_availability}}}

\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{B_SOILTYPE_AGR}{(character) The agricultural type of soil}

\item{A_SOM_LOI}{(numeric) The organic matter content of the soil (\%)}
}
\value{
The evaluated score for the soil function to supply potassium for crop uptake. A numeric value between 0 and 1.
}
\description{
This function calculates the indicator for the the Potassium Availability of the soil by using the K-availability calculated by \code{\link{calc_potassium_availability}}
}
\examples{
ind_potassium(D_K = 4.5,B_LU_BRP = 256,B_SOILTYPE_AGR='dekzand',A_SOM_LOI=4)
ind_potassium(c(2.5,3.5,6.5),c(256,1019,1019),rep('dekzand',3),c(3.5,4.5,7.5))
 
}
