% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_matrix.R
\name{model.matrix.opsr}
\alias{model.matrix.opsr}
\title{Construct Design Matrices for OPSR Model Fits}
\usage{
\method{model.matrix}{opsr}(object, data, .filter = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{"opsr"}.}

\item{data}{a data frame containing the terms from \code{object$formula}. Passed to
\code{\link{model.frame.opsr}}. Can be omitted.}

\item{.filter}{used internally in \code{\link{predict.opsr}} for counterfactual predictions.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list of lists with the design matrices \code{W} (selection process) and
\code{X} (outcome process). Both of these lists have \code{object$nReg} elements (a
separate design matrix for each regime).
}
\description{
Construct Design Matrices for OPSR Model Fits
}
\seealso{
\code{\link{model.frame.opsr}}, \code{\link[stats:model.matrix]{stats::model.matrix}}
}
