% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.Conf}
\alias{print.Conf}
\title{Prints all details about a Conf object.}
\usage{
\method{print}{Conf}(x, printfC = TRUE, printsC = TRUE, ...)
}
\arguments{
\item{x}{A Conf object as it is returned by \code{\link{conf}}-function.}

\item{printfC}{If TRUE, the sensitivities of the first classes are printed (TP = true positives).}

\item{printsC}{If TRUE, the values of sC are printed (TN = true negatives). The values of sC 
correspond to the rate of samples of a given class (column), which are assigned to the 
second class of the base classifier (row).}

\item{...}{Further parameters}
}
\description{
Prints all details about a Conf object.
}
\details{
Prints all details about a given Conf object. 
A Conf object provides the conditional prediction rates of all base classifiers applied to all classes.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')

conf = conf(predMap)

print(conf)
}
