% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_density.R
\name{ISE_fstar}
\alias{ISE_fstar}
\title{The ISE function in the kernel density estimation (KDE) context in the case when the underlying density is \code{\link{fstar}}.}
\usage{
ISE_fstar(h, n)
}
\arguments{
\item{h}{numerical vector of bandwidth values,}

\item{n}{sample size (number of data points generated from \code{\link{fstar}}).}
}
\value{
The vector of values of the ISE function for the correponsing vector of \eqn{h} values.
}
\description{
Computing the ISE function for the Gaussian density estimator obtained from a random sample of size \eqn{n} generated from \code{\link{fstar}}.
}
\details{
The integrated squared error (ISE) is a measure of closeness of the Gaussian density estimate computed from a data set generated from \code{\link{fstar}} to the true density.
}
\examples{
\dontrun{
dev.new()
harray=seq(0.05,1.5,len=1000)
ISEarray=ISE_fstar(harray,100)
h_ISE=round(harray[which.min(ISEarray)],digits=4)
dev.new()
plot(harray,ISEarray,lwd=3,'l',xlab="h",ylab="ISE",main="ISE(h)",cex.main=2,cex.lab=1.7,
cex.axis=1.7)
legend(0.35,ISEarray[5],legend=c("n=100",paste("h_ISE=",h_ISE)),cex=1.8,bty="n")
}
}
\references{
Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth density functions, arXiv:1703.05157.
}
\seealso{
\code{\link{fstar}}, \code{\link{sample_fstar}}.
}
