% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSCV_density.R
\name{fstar}
\alias{fstar}
\title{Nonsmooth density function with seven cusps.}
\usage{
fstar(u)
}
\arguments{
\item{u}{numerical vecror of argument values in the range [-3,3].}
}
\value{
The vector of values of \eqn{f^*} corresponding to the values of the vector \eqn{u}.
}
\description{
Nonsmooth density \eqn{f^*} with seven cusps introduced in the article of Savchuk (2017).
}
\details{
The function \eqn{f^*} consists of straight lines with different slopes connected together. The support of the density is [-3,3].
}
\examples{
\dontrun{
dev.new()
plot(seq(-3.5,3.5,len=1000),fstar(seq(-3.5,3.5,len=1000)),'l',lwd=3,
main="Nonsmooth density fstar with seven cusps", xlab="argument", ylab="density",cex.main=1.5,
cex.axis=1.7,cex.lab=1.7)
}
}
\references{
Savchuk, O.Y. (2017). One-sided cross-validation for nonsmooth density functions, arXiv:1703.05157.
}
\seealso{
\code{\link{sample_fstar}}, \code{\link{ISE_fstar}}.
}
