% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_data_collection_program.R
\name{manual_tree_intensity}
\alias{manual_tree_intensity}
\title{Manually Pre-Classify Activity Intensity}
\usage{
manual_tree_intensity(prompt_responses)
}
\arguments{
\item{prompt_responses}{A vector of responses to the decision tree prompts}
}
\description{
Manually implement the pre-classification decision tree described
    at the end of Supplemental Document 3 from \href{https://pubmed.ncbi.nlm.nih.gov/29135657/}{Hibbing et al. (2018,
*Med Sci Sports Exerc*)}.
}
\note{
The vector of responses must match the structure indicated in the
  example, i.e., a named vector answering prompts in the following order:
  participant seated; large muscles contracting; slow contractions;
  contractions slowed by resistance; activity is ambulatory; ambulation is
  slow enough to be considered light activity rather than moderate or
  vigorous.
}
\examples{
prompt_responses <- structure(c("yes", "no", NA, NA, NA, NA),
    .Dim = c(6L, 1L), .Dimnames = list(c("seated",
      "large_muscles_moving", "slow", "slowed_by_resistance",
      "ambulation", "light_walking"),
    "1"))

Observation:::manual_tree_intensity(prompt_responses)

}
\keyword{internal}
