\name{plot.iprofile}
\title{Plot Individual Time Profiles}
\usage{
plot.iprofile(z, nind=1, obs=TRUE, add=FALSE, plotsd=FALSE, lty=NULL,
	pch=NULL, ylab="Recursive fitted value", xlab="Time",
	main=NULL, ylim=NULL, xlim=NULL, ...)
}
\alias{plot.iprofile}
\arguments{
\item{z}{An object of class recursive, from \code{\link{carma}},
\code{\link{gar}}, \code{\link{kalcount}}, \code{\link{kalseries}},
\code{\link{kalsurv}}, or \code{\link{nbkal}}.}
\item{nind}{Observation number(s) of individual(s) to be plotted.}
\item{obs}{If TRUE, plots observed responses.}
\item{add}{If TRUE, the graph is added to an existing plot.}
\item{plotsd}{If TRUE, plots standard deviations around profile
(\code{\link{carma}} only).}
\item{others}{Plotting control options.}
}
\value{
\code{plot.iprofile} is used for plotting individual profiles over time
for models obtained from Kalman fitting. See
\code{\link{plot.profile}} for plotting marginal profiles.
}
\seealso{
\code{\link{carma}}, \code{\link{gar}}, \code{\link{kalcount}},
\code{\link{kalseries}}, \code{\link{kalsurv}}, \code{\link{nbkal}}
\code{\link{plot.profile}} \code{\link{plot.residuals}}.
}
\examples{
mu <- function(p) exp(p[1]-p[3])*(dose/(exp(p[1])-exp(p[2]))*
	(exp(-exp(p[2])*tt)-exp(-exp(p[1])*tt)))
shape <- function(p) exp(p[1]-p[2])*tt*dose*exp(-exp(p[1])*tt)
z <- gar(conc, dist="gamma", times, censor=censor, mu=mu, shape=shape,
	preg=c(0.89,-0.77,4), pdep=0.4, psh=c(-1.5,1.17), delta=0.01))
par(mfrow=c(3,3))
for(i in 1:9)
	plot.iprofile(z, i, ylim=c(0,5), xlim=c(1,24), main="Subject")
}
