% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseMissingData.R
\name{summariseMissingData}
\alias{summariseMissingData}
\title{Summarise missing data in omop tables}
\usage{
summariseMissingData(
  cdm,
  omopTableName,
  col = NULL,
  sex = FALSE,
  interval = "overall",
  ageGroup = NULL,
  sample = 1e+05,
  dateRange = NULL,
  year = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A \code{cdm_reference} object. Use \emph{CDMConnector} to create a reference
to a database or \emph{omock} to create a reference to synthetic data.}

\item{omopTableName}{A character vector of the names of the tables to
summarise in the cdm object. Run \code{clinicalTables()} to check the
available options.}

\item{col}{A character vector of column names to check for missing values.
If \code{NULL}, all columns in the specified tables are checked. Default is
\code{NULL}.}

\item{sex}{Logical; whether to stratify results by sex (\code{TRUE}) or not
(\code{FALSE}).}

\item{interval}{Time interval to stratify by. It can either be "years",
"quarters", "months" or "overall".}

\item{ageGroup}{A list of age groups to stratify the results by. Each element
represents a specific age range. You can give them specific names, e.g.
\code{ageGroup = list(children = c(0, 17), adult = c(18, Inf))}.}

\item{sample}{Either an integer or a character string.
\itemize{
\item If an integer (n > 0), the function will first sample \code{n} distinct
\code{person_id}s from the \code{person} table and then subset the input tables to
those subjects.
\item If a character string, it must be the name of a cohort in the \code{cdm}; in
this case, the input tables are subset to subjects (\code{subject_id}) belonging
to that cohort.
\item Use \code{NULL} to disable subsetting (default value).
}}

\item{dateRange}{A vector of two dates defining the desired study period.
Only the \code{start_date} column of the OMOP table is checked to ensure it falls within this range.
If \code{dateRange} is \code{NULL}, no restriction is applied.}

\item{year}{deprecated}
}
\value{
A \code{summarised_result} object with the results.
}
\description{
Summarise missing data in omop tables
}
\examples{
\donttest{
library(OmopSketch)
library(omock)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

result <- summariseMissingData(
  cdm = cdm,
  omopTableName = c("condition_occurrence", "visit_occurrence"),
  sample = 10000
)

tableMissingData(result = result)

cdmDisconnect(cdm = cdm)
}

}
