% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{ChildCancer_df}
\alias{ChildCancer_df}
\title{Childhood Cancer Data from North Portugal}
\format{
A data frame with 406 observations and 8 variables:
\describe{
  \item{X}{Unspecified numerical variable (numeric).}
  \item{U}{Unspecified numerical variable (numeric).}
  \item{V}{Unspecified numerical variable (numeric).}
  \item{ICCGroup}{Cancer group classification (numeric).}
  \item{Status}{Survival status of the child: 1 = alive, 2 = deceased (numeric).}
  \item{SurvTime}{Survival time in days (numeric).}
  \item{Residence}{Residence type of the child: 1 = urban, 2 = rural (numeric).}
  \item{Sex}{Sex of the child: 1 = male, 2 = female (numeric).}
}
}
\source{
Data taken from the DTDA package. The childhood cancer data were gathered from
the IPO (Registo Oncológico do Norte) service in North Portugal, kindly provided by
Doctor Maria José Bento.
}
\usage{
data(ChildCancer_df)
}
\description{
This dataset, ChildCancer_df, is a data frame containing information on 406 children
diagnosed with cancer between January 1, 1999, and December 31, 2003, in the region of
North Portugal. The dataset includes complete records on the age at diagnosis,
demographic details, and survival information. Due to the interval sampling, the age at
diagnosis is doubly truncated by the time from birth to the beginning and end of the study.
}
\details{
The dataset name has been kept as 'ChildCancer_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
OncoDataSets package and assists users in identifying its specific characteristics. The
suffix '_df' indicates that the dataset is a data frame. The original content has not been
modified in any way.
}
