% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{Carcinoma_p53_df}
\alias{Carcinoma_p53_df}
\title{Mutant p53 Gene and Squamous Cell Carcinoma}
\format{
A data frame with 6 observations and 5 variables:
\describe{
  \item{study}{Study identifier (integer).}
  \item{y1}{Unadjusted log hazard ratio for disease-free survival (numeric).}
  \item{y2}{Unadjusted log hazard ratio for overall survival (numeric).}
  \item{V1}{Variance of the log hazard ratio for disease-free survival (numeric).}
  \item{V2}{Variance of the log hazard ratio for overall survival (numeric).}
}
}
\source{
Data taken from the mixmeta package. References:
\itemize{
  \item Jackson D, Riley R, White IR (2011). Multivariate meta-analysis: Potential and promise. Statistics in Medicine. 30 (20);2481–2498.
  \item Tandon S, Tudur-Smith C, Riley RD, et al. (2010). A systematic review of p53 as a prognostic factor of survival in squamous cell carcinoma of the four main anatomical subsites of the head and neck. Cancer Epidemiology, Biomarkers and Prevention. 19 (2):574–587.
  \item Sera F, Armstrong B, Blangiardo M, Gasparrini A (2019). An extended mixed-effects framework for meta-analysis. Statistics in Medicine. 2019;38(29):5429–5444.
}
}
\usage{
data(Carcinoma_p53_df)
}
\description{
This dataset, Carcinoma_p53_df, is a data frame containing data related to the presence of the mutant p53 tumor suppressor gene
and its potential role as a prognostic factor in patients with squamous cell carcinoma arising from the oropharynx cavity.
The dataset includes unadjusted estimates of log hazard ratios for mutant p53 compared to normal p53 for disease-free and overall survival,
along with their associated variances, collected from 6 observational studies.
The dataset consists of 6 observations with 5 variables.
}
\details{
The dataset name has been kept as 'Carcinoma_p53_df' to avoid confusion with other datasets in the R ecosystem.
This naming convention helps distinguish this dataset as part of the OncoDataSets package and assists users in identifying
its specific characteristics. The suffix '_df' indicates that the dataset is a data frame. The original content has not been modified in any way.
}
