% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim.R
\name{Sim}
\alias{Sim}
\title{Calculate Empirical Power by Simulation for Two-Stage Designs Using
One-Sample Log-Rank Test}
\usage{
Sim(
  shape,
  S0,
  S1,
  x0,
  tf,
  rate,
  t1,
  c1,
  c,
  n1,
  n,
  N,
  restricted = 0,
  seed = 123
)
}
\arguments{
\item{shape}{shape parameter of the baseline hazard function assuming
Weibull distribution.}

\item{S0}{survival probability at a fixed time point x0 under the null
hypothesis.}

\item{S1}{survival probability at a fixed time point x0 under the
alternative hypothesis.}

\item{x0}{a fixed time point where the survival probabilities are known for
both null and alternative hypotheses.}

\item{tf}{the follow-up time, the time period from the entry of the last
patient to the end of the trial.}

\item{rate}{a constant accrual rate.}

\item{t1}{the interim analysis time as given by the two-stage design.}

\item{c1}{the critical value for the interim analysis as given by the
two-stage design.}

\item{c}{the critical value for the final analysis as given by the two-stage
design.}

\item{n1}{the required sample size for the interim analysis as given by the
two-stage design.}

\item{n}{the required total sample size for the entire trial as given by the
two-stage design.}

\item{N}{number of trials in the simulation.}

\item{restricted}{if restricted = 0 (default value), unrestricted follow-up
is used. If restricted = 1 or any other values, restricted follow-up is used.}

\item{seed}{seed for random number generation.}
}
\value{
a numeric value that is either the empirical power (when S1=S0^hr)
or the type I-error (when S1=S0).
}
\description{
Sim() can be used to calculate the empirical power and type-I error by
simulation given the design parameters obtained from the two-stage
designs using phase2.TTE().
}
\examples{
# calculate empirical power and type I error given design parameters
Sim(shape=1, S0=0.62, S1=0.62^(0.467), x0=2, tf=2, rate=5, t1=3.0593,
    c1=-0.302, c=1.6135, n1=16, n=26, N=10000, seed=5868)
# empirical power
# 0.813

Sim(shape=1, S0=0.62, S1=0.62, x0=2, tf=2, rate=5, t1=3.0593,
    c1=-0.302, c=1.6135, n1=16, n=26, N=10000, seed=5868)
# empirical type-I error
# 0.037
}
