% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenRange_sf.R
\name{OpenRange_sf}
\alias{OpenRange_sf}
\title{Download range maps that intersect a user-supplied sf object.}
\usage{
OpenRange_sf(
  sf,
  directory,
  species.names.only = FALSE,
  return.species.list = TRUE,
  crop.ranges = FALSE,
  include.gid = FALSE,
  projection = 4326,
  scenario = "present",
  default_only = TRUE,
  ...
)
}
\arguments{
\item{sf}{An object of class sf}

\item{directory}{Directory that range maps should be saved in.}

\item{species.names.only}{Return species names rather than spatial data? Default is FALSE.}

\item{return.species.list}{Should a species list be returned in addition to downloading range maps?  Default is FALSE}

\item{crop.ranges}{Should the ranges be cropped to the focal area? Default is FALSE.}

\item{include.gid}{Should the files returned have a unique GID appended to them? This is needed if downloading multiple maps for the same species.}

\item{projection}{Numeric. What projection should maps be returned in?  4326 (default) or 3857}

\item{scenario}{Which climate scenario should be represented by maps?  See BIEN_ranges_list_scenarios.}

\item{default_only}{Logical. Should only default ranges be included? Default is TRUE.}

\item{...}{Additional arguments passed to internal functions.}
}
\value{
All range maps that intersect the user-supplied shapefile.
}
\description{
OpenRange_sf extracts range maps that intersect a specified SpatialPolygons or SpatialPolygonsDataFrame object.
}
\note{
Details on the construction of BIEN range maps is available at https://bien.nceas.ucsb.edu/bien/biendata/bien-3/
}
\examples{
\donttest{

saguaro_poly <- OpenRange_load_species("Carnegiea gigantea")

#Create a temp directory
temp_dir <- file.path(tempdir(), "BIEN_temp")

#Get range maps for all species with ranges that overlap the range range of saguaros
OpenRange_sf(sf = saguaro_poly,
           directory = temp_dir)

#Note that this will save many sfs to the directory (or working directory)
}
}
\seealso{
Other range functions: 
\code{\link{OpenRange_api_load_species}()},
\code{\link{OpenRange_api_species}()},
\code{\link{OpenRange_get_license}()},
\code{\link{OpenRange_get_stats}()},
\code{\link{OpenRange_list_scenarios}()},
\code{\link{OpenRange_load_species}()},
\code{\link{OpenRange_species}()}
}
\concept{range functions}
