% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preferred_poles.R
\name{preferredPoles}
\alias{preferredPoles}
\alias{preferredPoles<-}
\title{Get / set preferred construct poles}
\usage{
preferredPoles(x)

preferredPoles(x) <- value
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{value}{Vector of with preferred poles. One of \code{'left'}, \code{'right'}, \code{'none'} or \code{NA}.
Abbreviations are allowsd (\code{'l'} for \code{'left'}).}
}
\description{
Constructs are bipolar, usually with one pole being preferred (positive).
Setting the preferred poles may is useful in some analyses.
}
\examples{
x <- fbb2003

preferredPoles(x) # no preferences assigned yet

# set preference by ideal rating
x <- preferredPolesByIdeal(x, ideal = "as I would love to be")
x <- preferredPolesByIdeal(x, ideal = 7) # same with element index
x

# set preferred poles manually
preferredPoles(x) <- c("left", "right", "left", "r", "l", "l", "l", "r", "r")
x

# change preferance for constructs 1 and 5
preferredPoles(x)[2] <- "left"
x

# remove prefernces
preferredPoles(x) <- NA
x
}
