% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_class_function.R
\name{OpenAP}
\alias{OpenAP}
\title{OpenAP Download}
\description{
Provides access to data from the Open Source Asset Pricing (OpenAP) project directly in R.
The package enables users to access two primary types of data:
\enumerate{
\item \strong{Predictor Portfolio Returns}:
\itemize{
\item Access 212 cross-sectional predictors.
\item Download portfolio returns using various portfolio construction methods, including original paper methods, deciles, quintiles, equal-weighted, value-weighted, price filters and more.
}
\item \strong{Firm Characteristics}:
\itemize{
\item Access 209 firm characteristics from OpenAP (+ 3 additional characteristics from CRSP (Price, Size, Short-term Reversal)).
}
}

Learn more about OpenAP: \href{https://www.openassetpricing.com}{Data website} | \href{https://github.com/OpenSourceAP/CrossSection}{GitHub code} | \href{https://www.nowpublishers.com/article/Details/CFR-0112}{Publication}
}
\examples{

## ------------------------------------------------
## Method `OpenAP$new`
## ------------------------------------------------

# Offline example
obj <- OpenAP$new(mock = TRUE)

# Real initialization (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  openap_24 <- OpenAP$new(release_year = "2024_10")
}

## ------------------------------------------------
## Method `OpenAP$list_port`
## ------------------------------------------------

# List available portfolios  (offline example)
openap <- OpenAP$new(mock = TRUE) 
openap$list_port()

# Real usage (internet connection required)
\dontrun{
  openap <- OpenAP$new()
  openap$list_port()
}

## ------------------------------------------------
## Method `OpenAP$dl_port`
## ------------------------------------------------

# Download entire portfolio file (offline example)
openap <- OpenAP$new(mock = TRUE)
df <- openap$dl_port("op")
# Download with specific predictor(s) only
df <- openap$dl_port("op", predictor = "Accruals")

# Real usage (internet connection required)
\dontrun{
  openap <- OpenAP$new()
  df <- openap$dl_port("op", predictor = "Accruals")
  df <- openap$dl_port("op", predictor = c("Accruals", "Mom12m"))
}

## ------------------------------------------------
## Method `OpenAP$dl_signal`
## ------------------------------------------------

# Download firm characteristics (offline example)
openap <- OpenAP$new(mock = TRUE)

# Single signal (OpenAP or WRDS)
df <- openap$dl_signal("BM")

# Multiple signals
df <- openap$dl_signal(c("BM", "STreversal"))

# Real usage (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  df <- openap$dl_signal("BM")
  df <- openap$dl_signal(c("BM", "STreversal"))
  df <- openap$dl_signal("BM", signed = FALSE)
}

## ------------------------------------------------
## Method `OpenAP$dl_all_signals`
## ------------------------------------------------

# Download all signals (offline example)
openap <- OpenAP$new(mock = TRUE)
signals_data <- openap$dl_all_signals()

# Real usage (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  signals_data <- openap$dl_all_signals()
}

## ------------------------------------------------
## Method `OpenAP$dl_signal_doc`
## ------------------------------------------------

# Load signal documentation (offline example)
openap <- OpenAP$new(mock = TRUE)
signal_doc <- openap$dl_signal_doc()
# Real usage (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  signal_doc <- openap$dl_signal_doc()
}
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name_id_map}}{A mapping between names and their corresponding IDs in the OpenAP database.}

\item{\code{individual_signal_id_map}}{A mapping of unique identifiers for individual signals.}

\item{\code{signal_sign}}{The direction or "sign" of the signal (i.e. positive or negative).}

\item{\code{url}}{The base URL for downloading OpenAP data.}

\item{\code{mock}}{Logical; if TRUE, network calls are skipped and mock data is returned for all download functions}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OpenAP-new}{\code{OpenAP$new()}}
\item \href{#method-OpenAP-list_port}{\code{OpenAP$list_port()}}
\item \href{#method-OpenAP-get_url}{\code{OpenAP$get_url()}}
\item \href{#method-OpenAP-dl_port}{\code{OpenAP$dl_port()}}
\item \href{#method-OpenAP-get_individual_signal_url}{\code{OpenAP$get_individual_signal_url()}}
\item \href{#method-OpenAP-dl_signal_crsp3}{\code{OpenAP$dl_signal_crsp3()}}
\item \href{#method-OpenAP-apply_sign_logic}{\code{OpenAP$apply_sign_logic()}}
\item \href{#method-OpenAP-merge_crsp_with_signals}{\code{OpenAP$merge_crsp_with_signals()}}
\item \href{#method-OpenAP-dl_signal}{\code{OpenAP$dl_signal()}}
\item \href{#method-OpenAP-dl_all_signals}{\code{OpenAP$dl_all_signals()}}
\item \href{#method-OpenAP-dl_signal_doc}{\code{OpenAP$dl_signal_doc()}}
\item \href{#method-OpenAP-clone}{\code{OpenAP$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-new"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-new}{}}}
\subsection{Method \code{new()}}{
Initializes the OpenAP class instance with data for the specified release year (or per default with the latest data).
Loads mappings, individual signal IDs and signal documentation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$new(release_year = NULL, mock = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{release_year}}{Optional release identifier, e.g. \code{"2024_08"}.}

\item{\code{mock}}{Logical; if TRUE, network initialization is skipped and
small mock datasets are returned instead of downloading data.
This is intended for examples, testing, and offline use.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Offline example
obj <- OpenAP$new(mock = TRUE)

# Real initialization (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  openap_24 <- OpenAP$new(release_year = "2024_10")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-list_port"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-list_port}{}}}
\subsection{Method \code{list_port()}}{
Returns a list of available portfolio types for the OpenAP dataset, depending on the specified release year.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$list_port()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# List available portfolios  (offline example)
openap <- OpenAP$new(mock = TRUE) 
openap$list_port()

# Real usage (internet connection required)
\dontrun{
  openap <- OpenAP$new()
  openap$list_port()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-get_url"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-get_url}{}}}
\subsection{Method \code{get_url()}}{
Retrieves the URL for a specific dataset based on its name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$get_url(data_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_name}}{The name of the Portfolio.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-dl_port"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-dl_port}{}}}
\subsection{Method \code{dl_port()}}{
Downloads portfolio data for a specified data set and optionally filters by predictor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$dl_port(data_name, predictor = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data_name}}{The name of the data set.}

\item{\code{predictor}}{A vector of predictor names to filter (optional).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Download entire portfolio file (offline example)
openap <- OpenAP$new(mock = TRUE)
df <- openap$dl_port("op")
# Download with specific predictor(s) only
df <- openap$dl_port("op", predictor = "Accruals")

# Real usage (internet connection required)
\dontrun{
  openap <- OpenAP$new()
  df <- openap$dl_port("op", predictor = "Accruals")
  df <- openap$dl_port("op", predictor = c("Accruals", "Mom12m"))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-get_individual_signal_url"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-get_individual_signal_url}{}}}
\subsection{Method \code{get_individual_signal_url()}}{
Retrieves the URL for an individual signal based on its name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$get_individual_signal_url(signal_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{signal_name}}{The name of the signal to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A string representing the URL of the signal.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-dl_signal_crsp3"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-dl_signal_crsp3}{}}}
\subsection{Method \code{dl_signal_crsp3()}}{
Is being used in "dl_signal()" to download CRSP signals. Requires WRDS credentials.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$dl_signal_crsp3(
  requested_crsp_signals = c("Price", "Size", "STreversal")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{requested_crsp_signals}}{A vector of CRSP signals to download.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-apply_sign_logic"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-apply_sign_logic}{}}}
\subsection{Method \code{apply_sign_logic()}}{
applies the sign logic to the data based on the signal documentation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$apply_sign_logic(data, predictors, signal_sign, signed = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{The data frame to apply the sign logic to.}

\item{\code{predictors}}{A vector of predictor names.}

\item{\code{signal_sign}}{A data frame containing the signal documentation.}

\item{\code{signed}}{Logical; whether to apply signed transformation based on signal documentation.
Default is TRUE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-merge_crsp_with_signals"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-merge_crsp_with_signals}{}}}
\subsection{Method \code{merge_crsp_with_signals()}}{
Merges downloaded OpenAP firm-level signals with CRSP-based signals
(e.g., Size, Price, STreversal).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$merge_crsp_with_signals(signals, crsp_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{signals}}{Data frame containing OpenAP firm-level signals with columns
\code{permno} and \code{yyyymm}.}

\item{\code{crsp_data}}{Data frame containing CRSP signals (e.g., Size, Price) with columns
\code{permno} and \code{yyyymm}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-dl_signal"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-dl_signal}{}}}
\subsection{Method \code{dl_signal()}}{
Downloads specific firm characteristics.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$dl_signal(predictor = NULL, signed = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{predictor}}{A vector of predictor names to download.}

\item{\code{signed}}{Logical; whether to apply signed transformation based on signal documentation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing the signal data.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Download firm characteristics (offline example)
openap <- OpenAP$new(mock = TRUE)

# Single signal (OpenAP or WRDS)
df <- openap$dl_signal("BM")

# Multiple signals
df <- openap$dl_signal(c("BM", "STreversal"))

# Real usage (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  df <- openap$dl_signal("BM")
  df <- openap$dl_signal(c("BM", "STreversal"))
  df <- openap$dl_signal("BM", signed = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-dl_all_signals"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-dl_all_signals}{}}}
\subsection{Method \code{dl_all_signals()}}{
Downloads all firm level characteristics from the release folder.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$dl_all_signals(signed = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{signed}}{Logical; whether to apply signed transformation based on signal documentation. Default is TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing all firm level characteristics.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Download all signals (offline example)
openap <- OpenAP$new(mock = TRUE)
signals_data <- openap$dl_all_signals()

# Real usage (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  signals_data <- openap$dl_all_signals()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-dl_signal_doc"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-dl_signal_doc}{}}}
\subsection{Method \code{dl_signal_doc()}}{
Downloads the signal documentation CSV for the release.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$dl_signal_doc()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A data frame containing the signal documentation.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Load signal documentation (offline example)
openap <- OpenAP$new(mock = TRUE)
signal_doc <- openap$dl_signal_doc()
# Real usage (requires internet connection)
\dontrun{
  openap <- OpenAP$new()
  signal_doc <- openap$dl_signal_doc()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OpenAP-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OpenAP-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OpenAP$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
