% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_intens.R
\name{smooth_intens}
\alias{smooth_intens}
\alias{smooth_intens.default}
\alias{smooth_intens.OpenSpecy}
\alias{calc_window_points}
\alias{calc_window_points.default}
\alias{calc_window_points.OpenSpecy}
\title{Smooth spectral intensities}
\usage{
smooth_intens(x, ...)

\method{smooth_intens}{default}(x, ...)

\method{smooth_intens}{OpenSpecy}(
  x,
  polynomial = 3,
  window = 11,
  derivative = 1,
  abs = TRUE,
  lambda = 1600,
  d = 2,
  type = "sg",
  lag = 2,
  make_rel = TRUE,
  ...
)

calc_window_points(x, ...)

\method{calc_window_points}{default}(x, wavenum_width = 70, ...)

\method{calc_window_points}{OpenSpecy}(x, wavenum_width = 70, ...)
}
\arguments{
\item{x}{an object of class \code{OpenSpecy} or vector for \code{calc_window_points()}.}

\item{polynomial}{polynomial order for the filter}

\item{window}{number of data points in the window, filter length (must be
odd).}

\item{derivative}{the derivative order if you want to calculate the
derivative. Zero (default) is no derivative.}

\item{abs}{logical; whether you want to calculate the absolute value of the
resulting output.}

\item{lambda}{smoothing parameter for Whittaker-Henderson smoothing, 50 results in rough smoothing and 10^4 results in a high level of smoothing.}

\item{d}{order of differences to use for Whittaker-Henderson smoothing, typically set to 2.}

\item{type}{the type of smoothing to use "wh" for Whittaker-Henerson or "sg" for Savitzky-Golay.}

\item{lag}{the lag to use for the numeric derivative calculation if using Whittaker-Henderson. Greater values lead to smoother derivatives, 1 or 2 is common.}

\item{make_rel}{logical; if \code{TRUE} spectra are automatically normalized
with \code{\link{make_rel}()}.}

\item{wavenum_width}{the width of the window you want in wavenumbers.}

\item{\ldots}{further arguments passed to \code{\link[signal]{sgolay}()}.}
}
\value{
\code{smooth_intens()} returns an \code{OpenSpecy} object.

\code{calc_window_points()} returns a single numberic vector object of the
number of points needed to fill the window and can be passed to \code{smooth_intens()}.
For many applications, this is more reusable than specifying a static number of points.
}
\description{
This smoother can enhance the signal to noise ratio of the data useing a
Savitzky-Golay or Whittaker-Henderson filter.
}
\details{
For Savitzky-Golay this is a wrapper around the filter function in the signal package to improve
integration with other Open Specy functions.
A typical good smooth can be achieved with 11 data point window and a 3rd or
4th order polynomial.
For Whittaker-Henderson, the code is largely based off of the whittaker() function in the pracma package.
In general Whittaker-Henderson is expected to be slower but more robust than Savitzky-Golay.
}
\examples{
data("raman_hdpe")

smooth_intens(raman_hdpe)

smooth_intens(raman_hdpe, window = calc_window_points(x = raman_hdpe, wavenum_width = 70))

smooth_intens(raman_hdpe, lambda = 1600, d = 2, lag = 2, type = "wh")

}
\references{
Savitzky A, Golay MJ (1964). “Smoothing and Differentiation of Data by
Simplified Least Squares Procedures.” \emph{Analytical Chemistry},
\strong{36}(8), 1627--1639.
}
\seealso{
\code{\link[signal]{sgolay}()}
}
\author{
Win Cowger, Zacharias Steinmetz
}
