% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGps.R
\name{addGps}
\alias{addGps}
\alias{addGps,data.frame-method}
\alias{addGps,AcousticEvent-method}
\alias{addGps,list-method}
\alias{addGps,AcousticStudy-method}
\alias{addGps,ANY-method}
\title{Add GPS Locations to an AcousticStudy}
\usage{
addGps(x, gps = NULL, thresh = 3600, ...)

\S4method{addGps}{data.frame}(x, gps, thresh = 3600, keepDiff = FALSE, ...)

\S4method{addGps}{AcousticEvent}(x, gps = NULL, thresh = 3600, ...)

\S4method{addGps}{list}(x, gps = NULL, thresh = 3600, ...)

\S4method{addGps}{AcousticStudy}(x, gps = NULL, thresh = 3600, ...)

\S4method{addGps}{ANY}(x, gps = NULL, thresh = 3600, ...)
}
\arguments{
\item{x}{data to add GPS coordinates to. Must have a column \code{UTC}, and
can also have an optional column \code{Channel}}

\item{gps}{a data frame of GPS coordinates to match to data from \code{x}.
Must have columns \code{UTC}, \code{Latitude}, \code{Longitude}, and
optionally \code{Channel}. If not provided and \code{x} is an
\linkS4class{AcousticEvent} or \linkS4class{AcousticStudy} object, then
the gps data will be read from the databases contained in the \code{files}
slot of \code{x}}

\item{thresh}{maximum time apart in seconds for matching GPS coordinates to
data, if the closest coordinate is more than \code{thresh} apart then the
Latitude and Longitude values will be set to \code{NA}}

\item{\dots}{additional arguments for other methods}

\item{keepDiff}{logical flag to keep time difference column (between GPS time
and data time)}
}
\value{
the same data as \code{x}, with Lat/Long data added. AcousticStudy objects
  will have all GPS data used added to the "gps" slot, and all AcousticEvents will
  have Latitude and Longitude added to all detector dataframes
}
\description{
Add GPS Lat / Long to an AcousticStudy or AcousticEvent.
  If GPS data is not present in any of the databases, user will
  interactively be asked to provide GPS data to add
}
\details{
Latitude and Longitude coordinates will be matched to the data
  by interpolating between points in the provided GPS data. After the
  interpolating is done, the time difference between the matched rows is checked
  and any that are greater than the set threshold are set to NA. This is
  done to prevent accidentally matching weird things if an incomplete set
  of GPS data is provided. An approximate distance between the interpolated
  points and the closest known GPS point is provided as a "gpsUncertainty"
  column (distance in meters).

  If \code{x} is an \linkS4class{AcousticEvent} or \linkS4class{AcousticStudy},
  then \code{gps} can be omitted and will be read from the databases contained
  in the \code{files} slot of \code{x}. If \code{x} is an \linkS4class{AcousticStudy},
  then the gps data will also be saved to the \code{gps} slot of the object, and
  an additional argument \code{bounds} can be provided. This is a length two vector
  of \code{POSIXct} class times that will bound the times of gps data to store, gps
  data outside this range will not be stored (to reduce the potentially very large
  amount of data stored in the \code{gps} slot)
}
\examples{

data(exStudy)
# need to update database file to local directory
db <- system.file('extdata', 'Example.sqlite3', package='PAMpal')
exStudy <- updateFiles(exStudy, db=db, bin=NA, verbose=FALSE)
exStudy <- addGps(exStudy)
head(gps(exStudy))

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
