% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatEffort.R
\name{formatEffort}
\alias{formatEffort}
\title{Format Detection Effort}
\usage{
formatEffort(
  effort,
  range = NULL,
  resolution = NULL,
  columns = NULL,
  combineYears = FALSE
)
}
\arguments{
\item{effort}{dataframe with columns \code{start} or \code{effortStart}
and \code{end} or \code{effortEnd} describing on effort time ranges}

\item{range}{if not \code{NULL}, the full extent time ranges to consider for
marking off effort times}

\item{resolution}{if not \code{NULL}, time resolution to round effort start
and end times to. Start times will use \link[lubridate]{floor_date} and
end times will use \link[lubridate]{ceiling_date}, must be a character
that is valid for the \code{unit} argument of those functions}

\item{columns}{if not \code{NULL}, extra columns to use for differentiating
different types of effort that should be tracked separately (e.g. different
deployment sites or species with different effort)}

\item{combineYears}{logical flag to combine all years into a single "year"}
}
\value{
a dataframe with columns \code{start}, \code{end}, and \code{status}
which is either "on" or "off", as well as any columns listed in \code{columns}
}
\description{
Format effort data for use in other acoustic detection plotting
functions. Time ranges will be marked as either "on" or "off" effort
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
