% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pam.nlm.R
\name{pam.nlm}
\alias{pam.nlm}
\title{Prediction Accuracy Measures for Nonlinear Regression Models.}
\usage{
pam.nlm(y, y.predict)
}
\arguments{
\item{y}{A numeric vector containing the response values.}

\item{y.predict}{A numeric vector containing the predicted response values from a fitted model.}
}
\value{
A list containing two components: R-squared and L-squared
}
\description{
This function calculates a pair of measures, R-Squared and L-Squared, for any nonlinear regression model. R-squared is an extension of the classical R2 statistic for a linear model, quantifying the amount of variability in the response that is explained by a corrected prediction based on the original prediction function. L-squared is the proportion of the prediction error of the original prediction function that is explained by the corrected prediction function, quantifying the distance between the corrected and uncorrected predictions. When used together, they give a complete summary of the predictive power of a prediction function.
}
\examples{
library(PAmeasures)

data(moore)

head(moore)

# Transistor count
count <- moore$count

time<-moore$time

# Fit a log-linear model
moore.glm= glm(log2(count) ~ time, family=gaussian(link = "identity") )

# Obtain predicted transistor count
count.predict<-2^(predict(moore.glm,newdata = data.frame(X = time),type = "response" ))

# R.squared and L.squared of log-linear model
pam.nlm(count, count.predict)
}
