% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_risk.R
\name{cvd_risk}
\alias{cvd_risk}
\alias{cvd_risk.default}
\alias{cvd_risk.data.frame}
\title{Calculate risk of cardiovascular disease}
\usage{
cvd_risk(
  x = NULL,
  method = "D'Agostino_2008",
  sex,
  age,
  total_cholesterol,
  hdl,
  systolic,
  bp_treated,
  diabetes,
  smoker,
  points = TRUE,
  ...
)

\method{cvd_risk}{default}(
  x = NULL,
  method = "D'Agostino_2008",
  sex,
  age,
  total_cholesterol,
  hdl,
  systolic,
  bp_treated,
  diabetes,
  smoker,
  points = TRUE,
  ...
)

\method{cvd_risk}{data.frame}(
  x = NULL,
  method = "D'Agostino_2008",
  sex,
  age,
  total_cholesterol,
  hdl,
  systolic,
  bp_treated,
  diabetes,
  smoker,
  points = TRUE,
  combine = TRUE,
  ...
)
}
\arguments{
\item{x}{optional data frame. If provided, the other arguments will be taken
as column names under the assumption that each row represents a separate
person, and each column provides one of the requested pieces of information}

\item{method}{character. Currently only \code{method = "D'Agostino_2008"} is
supported.}

\item{sex}{character scalar indicating either sex for one person (i.e.,
\code{male} or \code{female}), or a column name in \code{x} containing sex
values for multiple people}

\item{age}{either a numeric scalar indicating age for one person, or a
character scalar indicating the name of the column in \code{x} that
contains age information. Units are years}

\item{total_cholesterol}{same as \code{age}, but for total cholesterol, in mg/dL}

\item{hdl}{same as \code{age}, but for HDL, in mg/dL}

\item{systolic}{same as \code{age}, but for systolic blood pressure, in mmHg}

\item{bp_treated}{either a logical scalar indicating whether a person is
taking blood pressure medication, or a character scalar pointing to the
column in \code{x} that contains the same information for multiple people}

\item{diabetes}{same as \code{bp_treated}, but for the presence of diabetes}

\item{smoker}{same as\code{bp_treated}, but for smoking status}

\item{points}{logical. Return as points (default) or risk percentage?}

\item{...}{arguments passed to other methods}

\item{combine}{logical. Give results as a list of \code{risk_profile}
objects, or combine the list into an integer vector (default)?}
}
\value{
One or more risk profiles (for default method with \code{points = TRUE}, or for data frames with \code{combine = FALSE & points = TRUE}). Otherwise numeric risk percentage (for \code{points = FALSE}, scalars and data frames) or an integer vector (for data frames with \code{combine = TRUE & points = FALSE})
}
\description{
Calculate risk of cardiovascular disease
}
\examples{

cvd_risk(sex = "Female", age = 111, total_cholesterol = 111, systolic = 111,
hdl = 11, bp_treated = FALSE, diabetes = TRUE, smoker = TRUE)

\donttest{
df <- data.frame(
  sex = sample(c("Male", "Female"), 5, TRUE),
  age = sample(30:100, 5, TRUE),
  tc = sample(150:300, 5, TRUE),
  hdl = sample(30:70, 5, TRUE),
  sbp = sample(100:180, 5, TRUE),
  bpmed = sample(c(TRUE, FALSE), 5, TRUE),
  diabetes = sample(c(TRUE, FALSE), 5, TRUE),
  smoker = sample(c(TRUE, FALSE), 5, TRUE)
)

cvd_risk(
  df, sex = "sex", age = "age",
  total_cholesterol = "tc", hdl = "hdl",
  systolic = "sbp", bp_treated = "bpmed",
  diabetes = "diabetes", smoker = "smoker",
  combine = FALSE
)

}

}
\references{
\href{https://pubmed.ncbi.nlm.nih.gov/18212285/}{D'Agostino et al. (2008)}
}
