% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PCLasso}
\alias{plot.PCLasso}
\title{Plot coefficients from a PCLasso object}
\usage{
\method{plot}{PCLasso}(x, norm = TRUE, ...)
}
\arguments{
\item{x}{Fitted \code{PCLasso} model.}

\item{norm}{If TRUE, plot the norm of each group, rather than the individual
coefficients.}

\item{...}{Other graphical parameters to \code{plot}.}
}
\value{
No return value, called for plotting of \code{PCLasso} objects.
}
\description{
Produces a plot of the coefficient paths for a fitted
\code{PCLasso} object.
}
\examples{
# load data
data(survivalData)
data(PCGroups)

x = survivalData$Exp
y = survivalData$survData

PC.Human <- getPCGroups(Groups = PCGroups, Organism = "Human",
Type = "EntrezID")

# fit PCLasso model
fit.PCLasso <- PCLasso(x, y, group = PC.Human, penalty = "grLasso")

# plot the norm of each group
plot(fit.PCLasso, norm = TRUE)

# plot the individual coefficients
plot(fit.PCLasso, norm = FALSE)
}
\seealso{
\code{\link{PCLasso}}
}
