% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoa.sig.R, R/print.pcoasig.R,
%   R/print.summarypcoasig.R, R/summary.pcoasig.R
\encoding{UTF-8}
\name{pcoa.sig}
\alias{pcoa.sig}
\alias{print.pcoasig}
\alias{summary.pcoasig}
\alias{print.summarypcoasig}
\title{Significant dimensions in principal coordinate analysis}
\usage{
pcoa.sig(
  data,
  method = "gower",
  squareroot = FALSE,
  axis = 6,
  n.start = NULL,
  by = 1,
  iterations = 1000,
  parallel = NULL
)

\method{print}{pcoasig}(x, ...)

\method{print}{summarypcoasig}(x, ...)

\method{summary}{pcoasig}(object, choices = c(1, 2), ...)
}
\arguments{
\item{data}{Community data matrix.}

\item{method}{Method for dissimilarity index, as accepted by \code{\link[vegan]{vegdist}} (Default method = "gower").}

\item{squareroot}{Logical argument (TRUE or FALSE) to specify if use square root of dissimilarity 
index (Default squareroot = FALSE).}

\item{axis}{Maximum number of ordination principal axes to be monitored (Default axis = 6).}

\item{n.start}{Initial sample size. If n.start = NULL 
initial sample size is equal to total sample size (Default n.start = NULL).}

\item{by}{Sampling unit is added at each sampling step (Default by = 1).}

\item{iterations}{Number of permutations to assess significance (Default iterations = 1000).}

\item{parallel}{Number of parallel processes or a predefined socket cluster done with parallel package. Tip: use detectCores() (Default parallel = NULL).}

\item{x}{An object of class pcoasig.}

\item{...}{Other parameters for the respective functions.}

\item{object}{An object of class pcoasig.}

\item{choices}{Axes for re-scaling. Choices must have length equal to two (Default choices = c(1, 2)).}
}
\value{
\item{value}{The eigenvalues, relative eigenvalues and cumulative relative eigenvalues..} 
\item{vectors}{The principal coordinates.} \item{correlations}{Correlations
between axis and original data.} \item{mean.cor.null}{Mean correlations, for axis, between null and reference
scores.} \item{mean.cor.bootstrap}{Mean correlations, for axis, between bootstrap and reference scores.}
\item{n.permut.bootstrap}{Number of iterations for each axis in bootstrap step.}
\item{n.permut.null}{Number of iterations for each axis in null step.} \item{probabilities}{Probabilities for each axis.}
}
\description{
Function for determine the number of significant dimensions in principal coordinate analysis (PCoA).
}
\details{
At each iteration step a bootstrap sample is subjected to PCoA ordination, the scores are submitted 
to a procrustean adjustment, and the correlation between observed and bootstrap ordination scores 
is computed. It compares such correlations to the same parameter generated in a parallel bootstrapped
ordination of randomly permuted data. The number of axes in bootstrap or null PCoA with eigenvectors 
corresponding to positive eigenvalues may be smaller than the number of axes monitored, in this case, 
axes with values equal to 0 are created. The number of iterations with original values for each axis 
is shown in n.permut.bootstrap and n.permut.null. 

The function scores.pcoasig re-scales the correlation values for \code{\link{biplot}} graphics.
}
\note{
\strong{Principal Component Analysis (PCA)}

You can use the same function to determine the number of significant dimensions in principal component 
analysis (PCA). For this, standardize each variable for zero mean and uni variance (function decostand
and method standardize) and use euclidean distance as dissimilarity index.

\strong{Interpretation}

If the higher dimension is significant, then all lower dimensions will also be significant.
}
\examples{

\dontrun{
data(flona)
res<-pcoa.sig(flona$community, method = "bray", squareroot = TRUE, axis = 6, iterations = 100)
res
summary(res)$scores
}

}
\references{
Pillar, V.D. (1999). The bootstrapped ordination reexamined. Journal of Vegetation Science 10, 895-902.
}
\seealso{
\code{\link[ape]{pcoa}}, \code{\link[vegan]{procrustes}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{PCPS}
