% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_S3_method.R
\name{plot.PERSUADE}
\alias{plot.PERSUADE}
\title{Plot Method for PERSUADE Objects}
\usage{
\method{plot}{PERSUADE}(x, type = "km", ...)
}
\arguments{
\item{x}{A PERSUADE object from \code{f_PERSUADE()}.}

\item{type}{Character. The type of plot to produce.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns a list of results from the plotting functions.
Also produces base R plots as side effects.
}
\description{
Generates diagnostic and model fit plots for PERSUADE survival analysis objects.
The \code{type} argument controls which plot(s) are produced:
\itemize{
\item \code{"km"}: Kaplan-Meier survival curves.
\item \code{"ph"}: Proportional hazards diagnostics.
\item \code{"hr"}: Hazard function with fitted models.
\item \code{"param_models"}: Fitted parametric survival models with diagnostics and transition probability plots.
\item \code{"spline_models"}: Fitted spline-based survival models with diagnostics and transition probability plots.
\item \code{"cure_models"}: Fitted cure survival models with diagnostics and transition probability plots.
}
}
\examples{
\donttest{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
PERSUADE <- f_PERSUADE(
  name = "Example",
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  spline_mod = FALSE,
  cure_mod = FALSE,
  time_unit = 365.25/12,
  time_horizon = 2000,
  time_pred_surv_table = seq(0, 2000, 365.25)
)
plot(PERSUADE, "km")
}

}
