% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PERSUADE_function.R
\name{f_surv_model_excel}
\alias{f_surv_model_excel}
\title{Prepare Excel-Ready Survival Model Output}
\usage{
f_surv_model_excel(ngroups, strata, surv_model, spline_mod, cure_mod)
}
\arguments{
\item{ngroups}{Integer. Number of groups.}

\item{strata}{Logical. Whether stratified models were used.}

\item{surv_model}{List of fitted models from \code{\link[=f_surv_model]{f_surv_model()}}.}

\item{spline_mod}{Logical. Whether spline models were included.}

\item{cure_mod}{Logical. Whether cure models were included.}
}
\value{
A transposed data frame containing:
\itemize{
\item Distribution names
\item Parameter names
\item Estimates, SE, CI
\item Knot values (if splines fitted)
\item Covariance matrix
}
}
\description{
Formats model parameters (including spline knots) into a
table suitable for export to Excel.
}
\examples{
years <- survival::lung$time
status <-  survival::lung$status
group <- factor(survival::lung$sex)
form <- stats::as.formula(survival::Surv(years, status) ~ group)
surv_model <- f_surv_model(
  years = years,
  status = status,
  group = group,
  strata = FALSE,
  ngroups = nlevels(group),
  form = form,
  spline_mod = FALSE,
  cure_mod = FALSE,
  cure_link = "logistic",
  group_names = levels(group)
)
f_surv_model_excel(
  ngroups = nlevels(group),
  strata = FALSE,
  surv_model = surv_model,
  spline_mod = FALSE,
  cure_mod = FALSE
)

}
