% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfw_date.R
\name{pfw_date}
\alias{pfw_date}
\title{Filter Project FeederWatch Data by Month and/or Year}
\usage{
pfw_date(data, year = NULL, month = NULL)
}
\arguments{
\item{data}{A Project FeederWatch dataset.}

\item{year}{Optional. Integer or vector of years (e.g. 2010 or 2010:2015).}

\item{month}{Optional. Integer or vector of months (1–12). Supports wrapping (e.g. c(11:2) = Nov–Feb).}
}
\value{
A filtered dataset with date filter attributes.
}
\description{
This function filters Project FeederWatch data by year and/or month,
allowing range-based filtering and wrapping months around new years.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Download/load example dataset
data <- pfw_example

# Filter by a single year
data_2021 <- pfw_date(data, year = 2021)

# Filter by multiple years
data_2123 <- pfw_date(data, year = 2021:2023)

# Filter by a single month
data_feb <- pfw_date(data, month = 2)

# Filter by a span of months
data_winter <- pfw_date(data, month = 11:2)

# Filter by both year and month
data_filtered <- pfw_date(data, year = 2021:2023, month = 11:2)
\dontshow{\}) # examplesIf}
}
