% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phenthau.R
\name{phenthau}
\alias{phenthau}
\title{Calculate PHENTHAUproc model}
\usage{
phenthau(x, params = NULL, def_hatch = "first", budswelling = NULL)
}
\arguments{
\item{x}{SpatRaster list/SpatRaster/data.frame - numeric - with time
attribute/date column (see Details for Input requirements)}

\item{params}{list with parameter (see Details for Input requirements)}

\item{def_hatch}{"first" or "mean": PHENTHAUproc has three hatch models
integrated (for details see: Custers 2003, Wagenhoff et al. 2014, Meurisse et
al. 2012). With "first" (Default) the first hatch-model which predicts hatch,
with "mean", the mean day of all hatch-models will be used for further
calculations.}

\item{budswelling}{SpatRaster/numeric with DOY (Day of year) - If budswelling
is provided, internal calculation of budswelling will be replaced. For raster
input provide a raster with same extend and crs as x.}
}
\value{
data.frame or list of SpatRaster with all PHENTHAUproc model outputs
(see Details)
}
\description{
"phenthau" implements the early warning system PHENTHAUproc created by
Halbig et al. 2024 in R.
}
\details{
\strong{Overview}

phenthau function combines multiple phenology models:
\itemize{
\item bud swelling & leaf unfolding of \emph{Quercus robur} or
\emph{Quercus petraea}(still in development)
\item hatch of oak processionary moth using 3 different hatch models
(Custers 2003, Wagenhoff et al. 2014 and Meurisse et al. 2012)
\item development stages of OPM (0 egg - 8 adult)
}

\strong{Input requirements}

For different input type different parameter sets are needed. If params is
not provided it will be selected dependent on datatype and names(x) so follow
the name convention!

daily raster input with tmean, tmin and tmax:
\itemize{
\item a list of 3 named objects: "tmean", "tmin" and "tmax"
\item each object is a SpatRaster with one layer per day
\item terra::time for each SpatRaster has to be set to Date
-> parameter("dailymeanminmax", year)
}

daily raster input with tmean:
\itemize{
\item a SpatRaster
\item one layer per day
\item terra::time has to be set to Date
\item params has to be set manually!
-> parameter("dailymean", year)
}

hourly raster input:
\itemize{
\item a SpatRaster
\item one layer per hour
\item terra::time has to be set to Date
-> parameter("hour", year)
}

daily data.frame input with tmean, tmin and tmax:
\itemize{
\item a data.frame with 4 columns: "date", "tmean", "tmin", "tmax"
\item one row per day
-> parameter("dailymeanminmax", year)
}

daily data.frame input with tmean:
\itemize{
\item a data.frame with 2 columns: "date", "tmean"
\item one row per day
\item "date" column is.Date
-> parameter("dailymean", year)
}

hourly data.frame input:
\itemize{
\item a data.frame with 2 columns: "date", "hour", "tmean"
\item 24 rows per day
\item "date" column is.Date
-> parameter("hour", year)
}

\strong{Parametrisation}

Additional parametrization is provided but has not yet been tested.

Use parameter() to return a data.frame with all possible parametrization
options or choose a model.
The default is "dailymeanminmax" and not dependent on the data input anymore.
\itemize{
\item "dailymean": Regional PHENTHAUproc how described in Halbig et al. 2024 for
daily mean temperature data
\item "hour": Local PHENTHAUproc how described in Halbig et al. 2024 for hourly
temperature data
\item "dailymeanminmax": PHENTHAUproc for daily mean, max and min temperature
data adapted to open access DWD raster data
}

\strong{Output}

Regional Output: \cr
A list with all model calculations as SpatRaster objects:
\itemize{
\item stages: SpatRaster with one layer per day - numeric - values from 0-8
(0 egg stage - 8 adult stage).
-> use get_legend("stages") to show id/cover/colors
\item custers/wagenhoff/meurisse - one layer per day - logical - TRUE/FALSE for
hatch or no hatch
\item budswelling: one layer per day - logical - TRUE/FALSE for budswelling or no
budswelling
\item leafunfolding: one layer per day - logical - TRUE/FALSE for leafunfolding
or no leafunfolding
-> plot the first day of a logical SpatRaster with plot_date()
\item mortality: one layer - integer - mortality in \%
\item ppa_biocide: one layer per day - numeric - 0 application of plant
protection agents (PPA) and biocides not yet effective, 1 application
effective, 2 appliaction not effective anymore
}

Local Output: \cr
A data.frame with two columns:
\itemize{
\item model: name of model
\item date: date of first appearing of event
}

\strong{Presentation}

Regional Output:
\itemize{
\item plot_stages is a wrapper around terra::plot to preset legend, names, colors
and day to plot.
\item plot_date is a wrapper around terra::plot to plot the date of first TRUE in
multiple layered SpatRaster
}

Local Output:
\itemize{
\item plot_station_step is for local weather station data and creates a stepwise
graph for the development stages
}
}
\examples{

srl <- load_test()
phen <- phenthau(srl)
}
\references{
Halbig et al. 2024: Halbig, P., Stelzer, A. S., Baier, P., Pennerstorfer, J.,
Delb, H., & Schopf, A. (2024). PHENTHAUproc–An early warning and decision
support system for hazard assessment and control of oak processionary moth
(Thaumetopoea processionea). Forest Ecology and Management, 552, 121525 \cr
Custers 2003: Custers, C. (2003). Climate change and trophic synchronisation.
English Wageningen UR, Chairgroup Environmental Systems Analysis.\cr
Wagenhoff et al. 2014: Wagenhoff, E., Wagenhoff, A., Blum, R., Veit, H.,
Zapf, D., & Delb, H. (2014). Does the prediction of the time of egg hatch of
Thaumetopoea processionea (Lepidoptera: Notodontidae) using a frost
day/temperature sum model provide evidence of an increasing temporal mismatch
between the time of egg hatch and that of budburst of Quercus robur due to
recent global warming?. European Journal of Entomology, 111(2).\cr
Meurisse et al. 2012: Meurisse, N., Hoch, G., Schopf, A., Battisti, A.,
& Grégoire, J. C. (2012). Low temperature tolerance and starvation ability
of the oak processionary moth: implications in a context of increasing
epidemics. Agricultural and forest entomology, 14(3), 239-250.\cr
}
\seealso{
Other Main: 
\code{\link{get_legend}()},
\code{\link{mortality}()},
\code{\link{parameter}()},
\code{\link{phenology}()}
}
\author{
Bachfischer Lorenz, Department of Forest Protection FVA (2024)
\email{lorenz.bachfischer@posteo.de}
}
\concept{Main}
