% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_duration_scale.R
\name{apply_duration_scale}
\alias{apply_duration_scale}
\title{Apply infusion duration scale to a regimen}
\usage{
apply_duration_scale(
  regimen,
  duration_scale = NULL,
  parameters = NULL,
  cmt_mapping = NULL
)
}
\arguments{
\item{regimen}{PKPDsim regimen}

\item{duration_scale}{infusion length scale.}

\item{parameters}{parameter list, required if the duration scale is
specified as a parameter.}

\item{cmt_mapping}{map of administration types to compartments, e.g.
\code{list("oral" = 1, "infusion" = 2, "bolus" = 2)}.}
}
\value{
Original regimen with infusion lengths scaled by a factor
}
\description{
E.g. see Centanni et al. Clin Pharmacokinet 2024. An estimated scaling factor
for the length of the infusion was applied there in a model for vincristine.
This is likely most relevant for very short infusions.
}
\details{
Implementation is similar to handling of \code{lagtime}, i.e. the regimen that is the
input for the simulation function is updated.
}
