% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{envelope}
\alias{envelope}
\title{Normal Probability Plots with Simulated Envelope of Residuals for PLreg Objects}
\usage{
envelope(
  object,
  type = c("quantile", "deviance", "standardized"),
  rep = 40,
  conf = 0.95,
  xlab,
  ylab,
  main,
  envcol,
  ylim,
  xlim
)
}
\arguments{
\item{object}{fitted model object of class "\code{PLreg}".}

\item{type}{character specifying the type of residuals to be used,
see \code{\link{residuals.PLreg}}. Default is \code{type = "standardized"}.}

\item{rep}{a positive integer representing the number of iterations to calculate
the simulated envelopes. Default is \code{rep=40}.}

\item{conf}{a numeric value in the interval (0,1) that represents the confidence
level of the simulated envelopes. Default is \code{conf=0.95}.}

\item{xlab}{character specifying the label for \eqn{x} axis (optional). Default is
"\code{Quantile N(0,1)}".}

\item{ylab}{character specifying the label for \eqn{y} axis (optional). Default is
the name of the used residual.}

\item{main}{character specifying the overall title for the plot.}

\item{envcol}{character specifying the color of the envelope.}

\item{ylim, xlim}{numeric values, specifying the left/lower limit and the right/upper
limit of the scale.}
}
\value{
\code{envelope} returns normal probability plot with simulated envelopes
for the residuals.
}
\description{
\code{envelope} is used to display normal probability plots with simulated
envelope of residuals for the power logit models. Currently, three types of
residuals are supported: quantile, deviance and standardized residuals.
}
\details{
The \code{envelope} uses the idea of Atkinson (1985) to create normal
probability plots with simulated envelope. Under the correct model,
approximately 100*\code{conf} of the residuals are expected to be inside
the envelope.
}
\examples{
data("Firm")

fitPL <- PLreg(firmcost ~ sizelog + indcost | sizelog + indcost, data = Firm,
              family = "SLASH", zeta = 2.13)
summary(fitPL)
\donttest{
envelope(fitPL, type = "standardized")
envelope(fitPL, type = "quantile")
envelope(fitPL, type = "deviance")}

}
\references{
Queiroz, F. F. and Ferrari, S. L. P. (2022). Power logit regression
for modeling bounded data. \emph{arXiv}:2202.01697. \cr \cr
Atkinson, A. C. (1985) Plots, transformations and regression: an introduction
to graphical methods of diagnostic regression analysis.
\emph{Oxford Science Publications}, Oxford.
}
\seealso{
\code{\link{PLreg}}, \code{\link{residuals.PLreg}}
}
