% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testdata.R
\name{testdata}
\alias{testdata}
\alias{grohmann2015collaborative}
\alias{sas.logistic}
\title{Get Test Data}
\usage{
grohmann2015collaborative(lab = NULL)

sas.logistic()
}
\arguments{
\item{lab}{A numeric vector indicating from which laboratory the data should be taken.}
}
\value{
If a lab is not NULL, a data.frame with three columns ('X', 'S', 'N') is returned. If lab is NULL, these three columns are supplemented by a fourth column indicating the laboratory.

Data grohmann2015collaborative was generated by Grohmann et al. (2015) and has been used as exemplary data by Uhlig et al. (2015) to assess performance of their statistical approach to validate PCR results. 
Data sas.logistic was taken from the part of the SAS manual dealing with logistic regression (\url{https://support.sas.com/documentation/onlinedoc/stat/ex_code/132/logiex14.html}).
}
\description{
Some data to test the functionality of the package
}
\examples{
x.all <- grohmann2015collaborative()
x.5 <- grohmann2015collaborative(5)
sas <- sas.logistic()
}
\references{
Grohmann et al. Accred Qual Assur (2015) 20: 85. https://doi.org/10.1007/s00769-015-1108-5
Uhlig et al. Accred Qual Assur (2015) 20: 75. https://doi.org/10.1007/s00769-015-1112-9
}
