\name{loadPrismaData}
\alias{loadPrismaData}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Load PRISMA Data Files
}
\description{
  Loads files generated by the sally tool (see
  \url{http://www.mlsec.org/sally/}) and represents the data as binary
  token/ngrams x documents matrix. After loading, statistical tests are
  applied to find features which are not volatile nor
  constant. Co-occurring features are grouped to further compactify the
  data. See \code{system.file("extdata","sallyPreprocessing.py",
  package="PRISMA")} for a Python script which generates the
  corresponding .fsally file from a .sally file which reduce the
  loading time via \code{\link{loadPrismaData}} considerably.
}
\usage{
loadPrismaData(path, maxLines = -1, fastSally = TRUE,
               alpha = 0.05, skipFeatureCorrelation=FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{path}{
    path of the data file without the .sally extension. loadPrisma loads
    path.sally or path.fsally depending on the fastSally switch.
}
  \item{maxLines}{
    maximal number of lines to read from the data file. -1 means to read
    all lines.
}
  \item{fastSally}{
    should the fsally file be used, which drastically decreases loading time.
}
  \item{alpha}{
    significance level for the feature tests. If NULL, all features are kept.
}
  \item{skipFeatureCorrelation}{
    should the grouping of features based on correlation analysis be skipped.
}
}
\value{
  \item{prismaData}{data object representing the tokenized documents as
    features x samples matrix.}
}
\references{
  See \url{http://www.mlsec.org/sally/} for the sally utility.
}
\author{
Tammo Krueger <tammokrueger@googlemail.com>
}
\examples{
# please see the vingette for examles
# please see system.file("extdata","asap.tar.gz", package="PRISMA") for
# an example sally output
}
