% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lms2.cv.R
\name{Lms2.cv}
\alias{Lms2.cv}
\title{Logarithmic Minimum Test for Independence in Two-Way Contingency Table}
\usage{
Lms2.cv(nr, nc, n, alfa, B = 10000)
}
\arguments{
\item{nr}{a number of rows}

\item{nc}{a number of columns}

\item{n}{a sample size}

\item{alfa}{a significance level}

\item{B}{an integer specifying the number of replicates used in the Monte Carlo test (optional)}
}
\value{
The function returns the critical value of the logarithmic minimum test.
}
\description{
Calculates the critical values of the logarithmic minimum test.
}
\details{
The Critical value of the logarithmic minimum test for independence in r x c contingency table,
}
\examples{
\donttest{Lms2.cv(2, 2, 40, 0.05, B = 1e3)}
Lms2.cv(2, 3, 60, 0.1, B = 1e2)

}
\references{
{Sulewski, P. (2019). \emph{The LMS for Testing Independence in Two-way Contingency Tables.} Biometrical Letters 56(1), 17-43} #'
}
\author{
Piotr Sulewski, \email{piotr.sulewski@apsl.edu.pl}, Pomeranian University in Slupsk.
}
