% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mapindex}
\alias{mapindex}
\title{Index in one vector mapped to treatment and observation index}
\usage{
mapindex(r, n)
}
\arguments{
\item{r}{an integer between 1 and sum(n).}

\item{n}{a vector of the sample sizes.}
}
\value{
the 2-d index, where the first gives which treatment
        the value belongs to and the second gives which observation
        in that treatment.
}
\description{
Function mapindex() maps the 1-d index r=1,...,N to 2-d
index i=1, ...a, j=1, ..., ni. Generally the covariate values
from all treatments are stored together in one vector and
r=1,...,N enumerates the values. For any integer between 1 and N,
mapindex tells which treatment the rth value belongs to, and which
observation in the identified treatment.
}
\examples{
r=5; n=c(7, 8); mapindex(r, n)
r=7; n=c(7, 8); mapindex(r, n)
r=9; n=c(7, 8); mapindex(r, n)
}
