% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psw_balance.R
\name{psw.balance}
\alias{psw.balance}
\title{Balance checking using standardized mean difference}
\usage{
psw.balance(data, form.ps, weight, V.name = NULL, K = 4)
}
\arguments{
\item{data}{data frame to be used.}

\item{form.ps}{propensity score model.}

\item{weight}{weighting method to be used. Available methods are \code{"ATE"},  \code{"ATT"}, \code{"ATC"}, \code{"MW"}, \code{"OVERLAP"}, and \code{"TRAPEZOIDAL"}.}

\item{V.name}{a vector of covariates on which standardized mean difference is computed. If \code{V.name = NULL}, the covariates in propensity score model are used.}

\item{K}{value of \eqn{K} in \eqn{\omega(e_i) = min(1, K min(e_i, 1-e_i)) } for \code{"TRAPEZOIDAL"} weight.}
}
\value{
A list of weighting method, fitted propensity score model, estimated propenstity scores, estimated propensity score weights,
standardized mean difference before and after weighting adjustment.
\item{weight}{weighting method.}
\item{ps.model}{object returned by fitting the propensity score model using \code{glm} with \code{"binomial"} family.}
\item{ps.hat}{estimated propensity score.}
\item{W}{estimated propensity score weight.}
\item{std.diff.before}{A data frame of weighed mean, variance, and standardized mean difference for covariates in \code{V.name} by treatment groups before weighting.
\code{V.name} is the row name and \code{"treated.mean"}, \code{"treated.var"}, \code{"control.mean"}, \code{"control.var"}, \code{"std.diff.pct"} are column names.}
\item{std.diff.after}{A data frame of weighed mean, variance, and standardized mean difference for covariates in \code{V.name} by treatment groups after weighting.}
}
\description{
\code{psw.balance} is used to compute the standardized mean difference (in percentage) for balance diagnosis.
}
\examples{
# Load the test data set
data(test_data);
# Propensity score model
form.ps <- "Z ~ X1 + X2 + X3 + X4";
# A vector of covariates
V.name <- c( "X1", "X2", "X3", "X4" );
tmp <- psw.balance( data = test_data, weight = "MW", form.ps = form.ps,
V.name = V.name );

}
\seealso{
\link{psw}, \link{psw.spec.test}
}
