% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PanelBalance.R
\name{get_unrefined_balance.PanelBalance}
\alias{get_unrefined_balance.PanelBalance}
\title{Extract unrefined covariate balance results, if they exist}
\usage{
\method{get_unrefined_balance}{PanelBalance}(pb.object)
}
\arguments{
\item{pb.object}{\code{PanelBalance} object}
}
\value{
A \code{PanelBalance} object, with just the unrefined balance results
}
\description{
Extract unrefined covariate balance results, if they exist
}
\examples{
dem$rdata <- runif(runif(nrow(dem)))
dem.panel <- PanelData(dem, "wbcode2", "year", "dem", "y")
pm.obj <- PanelMatch(lead = 0:3, lag = 4, refinement.method = "mahalanobis", 
                     panel.data = dem.panel, match.missing = TRUE,
                     covs.formula = ~ tradewb + rdata + I(lag(tradewb, 1:4)) + I(lag(y, 1:4)), 
                     size.match = 5, qoi = "att")

# create multiple configurations to compare
pm2 <- PanelMatch(lead = 0:3, lag = 4, refinement.method = "ps.match", 
                  panel.data = dem.panel, match.missing = TRUE,
                  covs.formula = ~ tradewb + rdata + I(lag(tradewb, 1:4)) + I(lag(y, 1:4)), 
                  size.match = 5, qoi = "att")

pb <- get_covariate_balance(pm.obj, pm2,
                            include.unrefined = TRUE,
                            panel.data = dem.panel, 
                            covariates = c("tradewb", "rdata"))
get_unrefined_balance(pb)
}
