% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearningCurve.R
\name{plotLearningCurve}
\alias{plotLearningCurve}
\title{plotLearningCurve}
\usage{
plotLearningCurve(
  learningCurve,
  metric = "AUROC",
  abscissa = "events",
  plotTitle = "Learning Curve",
  plotSubtitle = NULL,
  fileName = NULL
)
}
\arguments{
\item{learningCurve}{An object returned by \code{\link{createLearningCurve}}
function.}

\item{metric}{Specifies the metric to be plotted:
\itemize{
\item{\code{'AUROC'} - use the area under the Receiver Operating
Characteristic curve}
\item{\code{'AUPRC'} - use the area under the Precision-Recall curve}
\item{\code{'sBrier'} - use the scaled Brier score}
}}

\item{abscissa}{Specify the abscissa metric to be plotted:
\itemize{
\item{\code{'events'} - use number of events}
\item{\code{'observations'} - use number of observations}
}}

\item{plotTitle}{Title of the learning curve plot.}

\item{plotSubtitle}{Subtitle of the learning curve plot.}

\item{fileName}{Filename of plot to be saved, for example \code{'plot.png'}.
See the function \code{ggsave} in the ggplot2 package for supported file
formats.}
}
\value{
A ggplot object. Use the \code{\link[ggplot2]{ggsave}} function to save to
file in a different format.
}
\description{
Create a plot of the learning curve using the object returned
from \code{createLearningCurve}.
}
\examples{
\dontshow{if (rlang::is_installed("parallel")) withAutoprint(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long to run }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1800, seed = 42)
outcomeId <- 3
modelSettings <- setLassoLogisticRegression(seed=42)
learningCurve <- createLearningCurve(plpData, outcomeId, modelSettings = modelSettings,
saveDirectory = file.path(tempdir(), "learningCurve"), parallel = FALSE)
plotLearningCurve(learningCurve)
}
\dontshow{\}) # examplesIf}
}
