% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SaveLoadPlp.R
\name{savePlpResult}
\alias{savePlpResult}
\title{Saves the result from runPlp into the location directory}
\usage{
savePlpResult(result, dirPath)
}
\arguments{
\item{result}{The result of running runPlp()}

\item{dirPath}{The directory to save the csv}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{                       The directory path where the results were saved
}\if{html}{\out{</div>}}
}
\description{
Saves the result from runPlp into the location directory
}
\details{
Saves the result from runPlp into the location directory
}
\examples{
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 1000, seed = 42)
saveLoc <- file.path(tempdir(), "savePlpResult")
results <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
# save the results
newSaveLoc <- file.path(tempdir(), "savePlpResult", "saved")
savePlpResult(results, newSaveLoc)
# show the saved results
dir(newSaveLoc, recursive = TRUE, full.names = TRUE)

# clean up
unlink(saveLoc, recursive = TRUE)
unlink(newSaveLoc, recursive = TRUE)
}
}
