% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sharpe}
\alias{sharpe}
\title{Compute Sharpe ratio}
\usage{
sharpe(X, na.rm = TRUE)
}
\arguments{
\item{X}{Vector (of length \eqn{T}) or matrix (of size \eqn{T \times
N}{TxN}) of returns for \eqn{N} funds. \code{NA} values are allowed.}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
stripped before the computation. Default \code{na.rm = TRUE}}
}
\value{
A scalar or a vector (of size \eqn{N}) with the Sharpe ratios.
}
\description{
Function which computes the Sharpe ratio.
}
\details{
The Sharpe ratio (Sharpe 1992) is one industry standard for measuring the
absolute risk adjusted performance of hedge funds.
}
\examples{
## Load the data
data('hfdata')

## Compute the Sharpe ratio
out = sharpe(hfdata)
print(out)

out = sharpe(hfdata, na.rm = FALSE)
print(out)
}
\references{
Ardia, D., Boudt, K. (2015).
Testing equality of modified Sharpe ratios.
\emph{Finance Research Letters} \bold{13}, pp.97--104.
\doi{10.1016/j.frl.2015.02.008}

Ardia, D., Boudt, K. (2016).
The Peer Ratios Performance of Hedge Funds.
\emph{Working paper}.
\doi{10.2139/ssrn.2000901}

Sharpe, W.F. (1994).
The Sharpe ratio.
\emph{Journal of Portfolio Management} \bold{21}(1), pp.49--58.
\doi{10.3905/jpm.1994.409501}
}
\seealso{
\code{\link{sharpeTesting}}, \code{\link{sharpeScreening}} and
\code{\link{msharpe}}.
}
\author{
David Ardia and Kris Boudt.
}
\keyword{htest}
