% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDAR.alpha.R
\name{CDaR.alpha}
\alias{CDaR.alpha}
\title{Conditional Drawdown alpha}
\usage{
CDaR.alpha(R, Rm, p = 0.95, weights = NULL, geometric = TRUE, type = NULL, ...)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of asset returns}

\item{Rm}{an xts, vector, matrix, data frame, timeSeries or zoo object of benchmark returns}

\item{p}{confidence level for calculation ,default(p=0.95)}

\item{weights}{portfolio weighting vector, default NULL}

\item{geometric}{utilize geometric chaining (TRUE) or simple/arithmetic chaining (FALSE) to aggregate returns, default TRUE}

\item{type}{(Optional) Overrides the p parameter. If "average" then p = 0 and if "max" then p = 1}

\item{\dots}{any passthru variable}
}
\value{
The annualized alpha (input data are assumed to be of monthly frequency)
}
\description{
The difference between the actual rate of return and the rate of
return of the instrument estimated via the conditional drawdown beta 
is called \eqn{CDaR.alpha} and it is the equivalent of the typical CAPM 
alpha but focusing on market drawdowns.

Positive \eqn{CDaR.alpha} implies that the instrument performed better than it was
predicted, and consequently, \eqn{CDaR.alpha} can be used as a performance
measure to rank instrument who overperform under market drawdowns.
}
\examples{
data(edhec)
CDaR.alpha(edhec[,1],edhec[,2])

CDaR.alpha(edhec[,1],edhec[,2],type="max")

CDaR.alpha(edhec[,1],edhec[,2],type="average") 

}
\references{
Zabarankin, M., Pavlikov, K., and S. Uryasev. Capital Asset Pricing Model 
(CAPM) with Drawdown Measure.Research Report 2012-9, ISE Dept., University 
of Florida,September 2012.
}
\seealso{
\code{\link{CDaR}} \code{\link{CDaR.beta}}
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>, Pulkit Mehrotra
}
