% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_CL_fit.r
\name{LP_CL_fit}
\alias{LP_CL_fit}
\title{Fit the Chen-Lloyd model to estimate abundance using a non-parametric smoother for a covariates}
\usage{
LP_CL_fit(
  data,
  covariate,
  centers = hist(data[, covariate, drop = TRUE], breaks = "Sturges", plot = FALSE)$mids,
  h1 = (centers[2] - centers[1]) * 0.75,
  h2 = (centers[2] - centers[1]) * 0.75,
  conf_level = 0.95
)
}
\arguments{
\item{data}{Data frame containing the variables:
\itemize{
\item \strong{cap_hist} Capture history (see details below)
\item \strong{freq} Number of times this capture history was observed
}
plus any other covariates (e.g. discrete strata and/or continuous covariates) to be used
in the model fitting.}

\item{covariate}{Name of continuous covariate that influences capture probabilities at each event}

\item{centers}{Centers of bins to group the covariates. We suggest no more than 30 bins in total
with fewer bins with smaller sample sizes. Of course with smaller sample sizes, a simple stratified
estimator may be easier to use.}

\item{h1, h2}{Standard deviation of normal kernel for first sampling event. This should be between 1/2 and the 1.5x the
bin width. Larger values imply more smoothing. Smaller values imply less smoothing.}

\item{conf_level}{The expected coverage for confidence intervals on N.}
}
\value{
An list object of class \emph{LP_CL_fit} with abundance estimates and other information with the following elements
\itemize{
\item \strong{summary} A data frame  with the estimates of abundance, SE, and CI
\item \strong{fit} Details on the Chen and Lloyd fit including the smoothed estimates of catchability, estimates abundance by category classes,
estimates of total abundance, plots of the estimated abundance curve and catchability curves, etc.
\item \strong{datetime} Date and time the fit was done
}
}
\description{
This will take a data frame of capture histories, frequencies, and a covariates
and will do a non-parametric smoother for the detection probabilities as a function
of the covariates and use this to estimate the population size.
}
\details{
The frequency variable (\code{freq} in the \code{data} argument) is the number of animals with the corresponding capture history.

Capture histories (\code{cap_hist} in the \code{data} argument) are character values of length 2.
\itemize{
\item \strong{10}  Animals tagged but never seen again.
\item \strong{11}  Animals tagged and recaptured and tag present at event 2.
\item \strong{01}  Animals captured at event 2 that appear to be untagged.
}
}
\examples{

library(Petersen)
data(data_NorthernPike)
res <- LP_CL_fit(data_NorthernPike, "length")
res$summary
}
\references{
SX Chen, CJ Lloyd (2000).
A nonparametric approach to the analysis of two-stage mark-recapture experiments.
Biometrika, 87, 633–649. \doi{10.1093/biomet/87.3.633}.
}
