% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMP.R
\name{GMP}
\alias{GMP}
\title{Geometric Mean Productivity (GMP)}
\usage{
GMP(Gen, YN, YS)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}
}
\value{
A data frame with \code{Gen}, \code{GMP}.

\deqn{GMP = \sqrt{YN \times YS}}
}
\description{
This function computes Geometric Mean Productivity (GMP) using any traits (like yield) under stress and non-stress conditions. The lower values of GMP indicates greater tolerance. For more details see Fernandez (1992).
}
\examples{
out=GMP(
Gen=c("G1","G2","G3"),
YN=c(10,8,5),
YS=c(7,5,3)
)
print(out)
}
\references{
Fernandez, G.C.J. (1992). Effective selection criteria for assessing plant stress tolerance. In: Proceedings of the international symposium on adaptation of vegetables and other food crops in temperature and water stress. AVRDC Publication: Tainan, Taiwan: Shanhua: Chapter (25), 257–270.
}
