% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STI.R
\name{STI}
\alias{STI}
\title{Stress Tolerance Index (STI)}
\usage{
STI(Gen, YN, YS, YMN = NULL)
}
\arguments{
\item{Gen}{Character vector of genotype identifiers.}

\item{YN}{Numeric vector: yield (any trait) under non-stress (normal) environment.}

\item{YS}{Numeric vector: yield (any trait) under stress environment.}

\item{YMN}{Optional numeric scalar: mean of \code{YN}. If NULL, computed as \code{mean(YN, na.rm=TRUE)}.}
}
\value{
A list of components:
\itemize{
\item \code{YMN}: Mean of yield (any trait) values under normal condition
\item \code{Result}: It includes
\itemize{
\item \code{Gen}: Character vector of genotype IDs.
\item \code{STI}: Estimated stress tolerance index (STI) values for respective genotypes.
}
}
\deqn{STI = \frac{YN \times YS}{(YMN)^2}}
}
\description{
This function computes stress tolerance index (STI) using any traits (like yield) under stress and non-stress conditions. The lower values of STI indicates greater tolerance. For more details see Fernandez (1992).
}
\examples{
out=STI(Gen=c("G1","G2","G3"), YN=c(10,8,5), YS=c(7,5,3))
print(out)
}
\references{
Fernandez, G.C.J. (1992). Effective selection criteria for assessing plant stress tolerance. In: Proceedings of the international symposium on adaptation of vegetables and other food crops in temperature and water stress. AVRDC Publication: Tainan, Taiwan: Shanhua: Chapter (25), 257–270.
}
