% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PieceExpIntensity2}
\alias{PieceExpIntensity2}
\title{C++ Sampling Function for MCMC}
\usage{
PieceExpIntensity2(Y, Rates, B, Poi)
}
\arguments{
\item{Y}{Vector containing observed event times.}

\item{Rates}{Vector containing poisson count intensities.}

\item{B}{Number of iterations to run the MCMC with half burned in.}

\item{Poi}{Prior mean number of split points,}
}
\value{
A list of all posterior quantities.
}
\description{
C++ Sampling Function used in the PieceExpIntensity function.
}
\examples{
B=1000
n=100
Y=rexp(n,1)
Rates=Y
Rates[Y<.5]=rpois(sum(Y<.5),20)
Rates[Y>.5]=rpois(sum(Y>.5),3)
Poi=10
PieceExpIntensity2(Y,Rates,B,Poi)
}
