test_that("Peak finder works", {
  mylar <- read.csv(
    test_path('data', 'Calib_greasedMylar0125_1_nA42.599083_PESA.csv'),
    header = FALSE) %>%
    mutate(Ch = seq_along(V1)) %>%
    select(Ch, CPS = V1)
  expect_equal(find_peaks(mylar, 'Ch', 'CPS'),
               tibble(X=c(217, 323), Y=c(1352, 3000)))
})
test_that("ROI blocks edge peaks", {
  jadeite <- readRDS(test_path('data', 'jadeite_control.rds'))
  expect_equal(find_peaks(jadeite, 'Ch', 'CPS', asFraction=FALSE, minYerror=5500, ROI=c(0, 500)),
               tibble(X=c(129, 155, 184, 214, 403, 452, 491),
                      Y=c(32702, 45298, 382405, 1048170, 27282, 58156, 12029)))
  expect_equal(find_peaks(jadeite, 'Ch', 'CPS', minYerror=0, ROI=c(480, 500)),
               tibble(X=491, Y=12029))
})
test_that("sum_line works", {
  expect_equal(sum_line(c(0, 1, 1, 0, 0, 0, 1, 2, 0)),
               c(0, 1, 2, 2, 2, 2, 3, 5, 5))
})
