% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPODBAYEfficacy.R
\name{EfficacyCICoverage}
\alias{EfficacyCICoverage}
\title{PoDBAY efficacy summary at three confidence levels}
\usage{
EfficacyCICoverage(efficacySet, ci = 0.95)
}
\arguments{
\item{efficacySet}{numeric vector: estimated PoDBAY efficacies from \code{PoDBAYEfficacy} function.}

\item{ci}{numeric: value from (0, 1) interval, confidence level of interest}
}
\value{
named list: mean, median, CILow, CIHigh
}
\description{
Function summarizes PoDBAY efficacy statistics (mean, median, confidence intervals) at 80\%, 90\% and user-defined confidence levels, based on the set of estimated efficacies. (Set of efficacies is a vector obtained by number of replications specified by repeatCount. These replications are performed for calculation of a confidence interval. For more details, see the supplementary material of the article).
}
\details{
Confidence intervals are calculated using quantiles of estimated efficacies.
}
\examples{
## Data preparation
data(efficacySet)

## Example 1
EfficacyCICoverage(efficacySet, ci = 0.95)

}
