% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsPopulationGeneration.R
\name{generatePopulation}
\alias{generatePopulation}
\title{Population class object generation}
\usage{
generatePopulation(N, mean, stdDev, unknownDistribution = FALSE, UDFunction = NULL)
}
\arguments{
\item{N}{numeric: number of subjects in the population}

\item{mean}{numeric: mean of titers}

\item{stdDev}{numeric: standard deviation of titers}

\item{unknownDistribution}{logical: TRUE if there is an unknown factor affacting the shape of titer distribution}

\item{UDFunction}{function: function defining the unknown factor affecting the shape of titer distribution}
}
\value{
generated population class object with all its characteristics defined in the input parameters
}
\description{
Function generates the population class object using provided summary statistics.
}
\examples{

# Example 1: empty population
population0 <- generatePopulation()

# Example 2
population1 <- generatePopulation(N = 100,
                                  mean = 5,
                                  stdDev = 2)

}
